import type { Config } from "tailwindcss";

export default {
  content: [
    "./src/app/**/*.{ts,tsx}",
    "./src/components/**/*.{ts,tsx}",
  ],
  theme: {
    extend: {
      fontFamily: {
        brand: ['"ABeeZee"', "ui-sans-serif", "system-ui", "sans-serif"],
      },
      colors: {
        thebe: {
          bg: "#F8FAFC",
          text: "#0F172A",
          border: "#E2E8F0",
          blue: "#1E3A8A",
          blue2: "#2563EB",
          success: "#16A34A",
          warn: "#F59E0B",
          danger: "#DC2626"
        }
      },
      borderRadius: {
        xl2: "18px"
      },
      boxShadow: {
        soft: "0 10px 25px rgba(15, 23, 42, 0.08)",
        soft2: "0 8px 20px rgba(15, 23, 42, 0.10)"
      }
    },
  },
  plugins: [],
} satisfies Config;
