import { Card } from "@/components/ui/Card";
import Link from "next/link";

export default function IssuerDashboard() {
  return (
    <div className="space-y-6">
      <Card>
        <h1 className="text-2xl font-semibold">Issuer Dashboard</h1>
        <p className="mt-2 text-sm text-slate-600">
          Review routed applications, request info, approve/decline, and send offers.
        </p>
        <div className="mt-4 flex gap-3">
          <Link href="/issuer/applications" className="text-sm text-thebe-blue2 hover:underline">Open inbox</Link>
          <Link href="/issuer/products" className="text-sm text-thebe-blue2 hover:underline">Configure products</Link>
        </div>
      </Card>
    </div>
  );
}
