import { AppShell } from "@/components/AppShell";

export default function IssuerLayout({ children }: { children: React.ReactNode }) {
  return (
    <AppShell
      title="Issuer Portal"
      roleLabel="Issuer"
      nav={[
        { href: "/issuer", label: "Dashboard" },
        { href: "/issuer/onboarding", label: "Onboarding" },
        { href: "/issuer/products", label: "Products & Rules" },
        { href: "/issuer/applications", label: "Applications Inbox" },
        { href: "/issuer/offers", label: "Offers" },
        { href: "/issuer/billing", label: "Billing" },
        { href: "/issuer/reports", label: "Reports" },
      ]}
    >
      {children}
    </AppShell>
  );
}
