import { AppShell } from "@/components/AppShell";

export default function BorrowerLayout({ children }: { children: React.ReactNode }) {
  return (
    <AppShell
      title="Borrower Portal"
      roleLabel="Borrower"
      nav={[
        { href: "/app", label: "Dashboard" },
        { href: "/app/apply", label: "Apply" },
        { href: "/app/applications", label: "My Applications" },
        { href: "/app/offers", label: "My Offers" },
        { href: "/app/loans", label: "My Loans" },
        { href: "/app/payments", label: "My Payments" },
        { href: "/app/credit-profile", label: "Credit Profile" },
        { href: "/app/support", label: "Talk to Us" },
        { href: "/app/account", label: "My Account & KYC" },
      ]}
    >
      {children}
    </AppShell>
  );
}
