import { Card } from "@/components/ui/Card";
import { Button } from "@/components/ui/Button";
import Link from "next/link";

export default function ApplyPage() {
  return (
    <div className="space-y-6">
      <Card>
        <h1 className="text-2xl font-semibold">Start an application</h1>
        <p className="mt-2 text-slate-600 text-sm">
          Choose Personal or Business, then complete the wizard. Serious KYC is required before submitting.
        </p>
      </Card>

      <div className="grid grid-cols-1 md:grid-cols-2 gap-6">
        <Card>
          <div className="text-lg font-semibold">Personal</div>
          <p className="mt-2 text-sm text-slate-600">Salary-based or personal income applications.</p>
          <div className="mt-4">
            <Link href="/app/apply/personal"><Button className="w-full">Continue</Button></Link>
          </div>
        </Card>
        <Card>
          <div className="text-lg font-semibold">Business</div>
          <p className="mt-2 text-sm text-slate-600">Enterprise loans, PO finance and business credit needs.</p>
          <div className="mt-4">
            <Link href="/app/apply/business"><Button className="w-full">Continue</Button></Link>
          </div>
        </Card>
      </div>
    </div>
  );
}
