import Link from "next/link";
import { Card } from "@/components/ui/Card";
import { Badge } from "@/components/ui/Badge";
import { supabaseServer } from "@/lib/supabase/server";

export default async function ApplicationsPage() {
  const supabase = supabaseServer();
  const { data: { user } } = await supabase.auth.getUser();

  const { data: apps } = await supabase
    .from("applications")
    .select("id,status,amount_requested,term_requested,created_at")
    .eq("user_id", user?.id ?? "")
    .order("created_at", { ascending: false });

  return (
    <Card>
      <div className="flex items-center justify-between">
        <h1 className="text-2xl font-semibold">My Applications</h1>
        <Link href="/app/apply" className="text-sm text-thebe-blue2 hover:underline">New application</Link>
      </div>
      <div className="mt-4 space-y-3">
        {(apps ?? []).length === 0 ? (
          <div className="text-sm text-slate-600">No applications yet.</div>
        ) : (
          (apps ?? []).map((a) => (
            <Link
              key={a.id}
              href={`/app/applications/${a.id}`}
              className="block rounded-xl2 border border-thebe-border bg-slate-50 px-4 py-3 hover:bg-slate-100"
            >
              <div className="flex items-center justify-between">
                <div>
                  <div className="text-sm font-medium">Application #{String(a.id).slice(0, 8)}</div>
                  <div className="text-xs text-slate-500">
                    Amount: P{a.amount_requested} • Term: {a.term_requested} months
                  </div>
                </div>
                <Badge tone="blue">{a.status}</Badge>
              </div>
            </Link>
          ))
        )}
      </div>
    </Card>
  );
}
