import { NextResponse } from "next/server";
import { supabaseServer } from "@/lib/supabase/server";

export async function POST(req: Request) {
  const form = await req.formData();
  const application_id = String(form.get("application_id") ?? "");
  if (!application_id) return NextResponse.json({ error: "Missing application_id" }, { status: 400 });

  const supabase = supabaseServer();
  const { data: { user } } = await supabase.auth.getUser();
  if (!user) return NextResponse.json({ error: "Not authenticated" }, { status: 401 });

  await supabase.from("applications").delete().eq("id", application_id).eq("user_id", user.id);
  return NextResponse.redirect(new URL(`/app/applications`, req.url));
}
