import { AppShell } from "@/components/AppShell";

export default function AdminLayout({ children }: { children: React.ReactNode }) {
  return (
    <AppShell
      title="Admin Oversight"
      roleLabel="Admin"
      nav={[
        { href: "/admin", label: "Overview" },
        { href: "/admin/issuers", label: "Issuers" },
        { href: "/admin/borrowers", label: "Borrowers" },
        { href: "/admin/kyc", label: "KYC Queue" },
        { href: "/admin/applications", label: "Applications" },
        { href: "/admin/routing", label: "Routing Rules" },
        { href: "/admin/content", label: "Content" },
        { href: "/admin/tickets", label: "Tickets" },
        { href: "/admin/audit", label: "Audit Logs" },
        { href: "/admin/analytics", label: "Analytics" },
      ]}
    >
      {children}
    </AppShell>
  );
}
