import Link from "next/link";
import { NavBar } from "@/components/NavBar";
import { Card } from "@/components/ui/Card";

export default function Page() {
  return (
    <div className="min-h-screen bg-thebe-bg">
      <NavBar />
      <div className="container py-10">
        <Card>
          <h1 className="text-2xl font-semibold">Rates & Fees</h1>
          <p className="mt-3 text-slate-600">Rates vary by issuer and borrower profile. Offers will show APR/rate, fees and repayment schedules transparently before you accept.</p>
          <div className="mt-5 text-sm">
            <Link href="/" className="text-thebe-blue2 hover:underline">Back home</Link>
          </div>
        </Card>
      </div>
    </div>
  );
}
