import Link from "next/link";
import { NavBar } from "@/components/NavBar";
import { Button } from "@/components/ui/Button";
import { Card } from "@/components/ui/Card";
import { Badge } from "@/components/ui/Badge";

export default function HomePage() {
  return (
    <div className="min-h-screen bg-thebe-bg">
      <NavBar />
      <section className="container py-14">
        <div className="grid grid-cols-1 lg:grid-cols-2 gap-10 items-center">
          <div>
            <Badge tone="blue">Botswana-first • Blue Trust</Badge>
            <h1 className="mt-4 text-4xl md:text-5xl font-semibold leading-tight text-thebe-text">
              Apply once. Get offers from multiple lenders.
            </h1>
            <p className="mt-4 text-slate-600 text-base md:text-lg">
              Thebe routes your application to approved issuers, lets you compare offers,
              and gives you one dashboard to track and pay — without Thebe ever handling loan funds.
            </p>
            <div className="mt-6 flex flex-wrap gap-3">
              <Link href="/register"><Button className="px-6">Start application</Button></Link>
              <Link href="/how-it-works"><Button variant="secondary" className="px-6">How it works</Button></Link>
            </div>
            <div className="mt-8 grid grid-cols-2 gap-3 text-sm text-slate-600">
              <div className="rounded-xl2 border border-thebe-border bg-white p-4 shadow-soft">
                <div className="font-medium text-thebe-text">Serious KYC</div>
                <div className="mt-1">Omang + proof of address workflows.</div>
              </div>
              <div className="rounded-xl2 border border-thebe-border bg-white p-4 shadow-soft">
                <div className="font-medium text-thebe-text">Offer compare</div>
                <div className="mt-1">APR, fees, term, monthly estimate.</div>
              </div>
            </div>
          </div>

          <Card className="p-6">
            <div className="text-sm font-semibold text-thebe-text">Easy as 1, 2, 3</div>
            <ol className="mt-4 space-y-4 text-sm text-slate-700">
              <li className="flex gap-3">
                <div className="h-8 w-8 rounded-xl2 bg-blue-50 text-thebe-blue2 flex items-center justify-center font-semibold">1</div>
                <div>
                  <div className="font-medium">Apply</div>
                  <div className="text-slate-500">Personal or Business — upload required documents.</div>
                </div>
              </li>
              <li className="flex gap-3">
                <div className="h-8 w-8 rounded-xl2 bg-blue-50 text-thebe-blue2 flex items-center justify-center font-semibold">2</div>
                <div>
                  <div className="font-medium">Get offers</div>
                  <div className="text-slate-500">We route to multiple issuers that match your profile.</div>
                </div>
              </li>
              <li className="flex gap-3">
                <div className="h-8 w-8 rounded-xl2 bg-blue-50 text-thebe-blue2 flex items-center justify-center font-semibold">3</div>
                <div>
                  <div className="font-medium">Track & pay</div>
                  <div className="text-slate-500">One dashboard for schedules, receipts, and proof uploads.</div>
                </div>
              </li>
            </ol>
            <div className="mt-6 flex gap-3">
              <Link href="/loan-types"><Button variant="secondary" className="w-full">Explore loan types</Button></Link>
              <Link href="/register"><Button className="w-full">Get started</Button></Link>
            </div>
          </Card>
        </div>
      </section>

      <footer className="border-t border-thebe-border bg-white">
        <div className="container py-8 text-sm text-slate-500 flex flex-wrap gap-4 justify-between">
          <div>© {new Date().getFullYear()} Thebe</div>
          <div className="flex gap-4">
            <Link href="/legal/privacy" className="hover:text-thebe-blue2">Privacy</Link>
            <Link href="/legal/terms" className="hover:text-thebe-blue2">Terms</Link>
            <Link href="/contact" className="hover:text-thebe-blue2">Contact</Link>
          </div>
        </div>
      </footer>
    </div>
  );
}
