import Link from "next/link";
import { NavBar } from "@/components/NavBar";
import { Card } from "@/components/ui/Card";

export default function Page() {
  return (
    <div className="min-h-screen bg-thebe-bg">
      <NavBar />
      <div className="container py-10">
        <Card>
          <h1 className="text-2xl font-semibold">How Thebe works</h1>
          <p className="mt-3 text-slate-600">Apply once, Thebe routes your application to approved issuers, you compare offers, accept one, and the issuer disburses funds. Thebe provides tracking, payments, receipts and support in one place.</p>
          <div className="mt-5 text-sm">
            <Link href="/" className="text-thebe-blue2 hover:underline">Back home</Link>
          </div>
        </Card>
      </div>
    </div>
  );
}
